/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.resource;

import com.vistara.sdk.utils.APIConstants;
import com.vistara.sdk.utils.SdkUtil;

public class ResourceAPIClient
implements APIConstants {
    private static ResourceAPIClient _instance = null;
    private String apiBaseURI = null;
    private String tenantId = null;
    private String appName = null;
    private String authType = "Oauth2";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceAPIClient getInstance(String tenantId, String integrationName) throws Exception {
        if (_instance != null) return _instance;
        Class<ResourceAPIClient> clazz = ResourceAPIClient.class;
        synchronized (ResourceAPIClient.class) {
            if (_instance != null) return _instance;
            _instance = new ResourceAPIClient(tenantId, integrationName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceAPIClient getInstance(String tenantId) throws Exception {
        if (_instance != null) return _instance;
        Class<ResourceAPIClient> clazz = ResourceAPIClient.class;
        synchronized (ResourceAPIClient.class) {
            if (_instance != null) return _instance;
            _instance = new ResourceAPIClient(tenantId);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _instance;
        }
    }

    public ResourceAPIClient(String tenantId, String integrationName) throws Exception {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new Exception("Tenant Id should not be null or empty.");
        }
        if (integrationName == null || integrationName.isEmpty()) {
            throw new Exception("Integration Name should not be null or empty.");
        }
        this.tenantId = tenantId;
        this.appName = integrationName;
    }

    public ResourceAPIClient(String tenantId) throws Exception {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new Exception("Tenant Id should not be null or empty.");
        }
        this.tenantId = tenantId;
    }

    public String deleteResource(long resourceId) throws Exception {
        if (resourceId <= 0L) {
            throw new Exception("Invalid Resource Id : " + resourceId);
        }
        String apiURL = this.getAPIURL("/resource/" + resourceId);
        return SdkUtil.getInstance().deleteRequest(apiURL);
    }

    public String deleteResource(String resourceType, String resourceId) throws Exception {
        if (resourceType == null || resourceType.isEmpty()) {
            throw new Exception("Resource Type should not be null or empty");
        }
        if (resourceId == null || resourceId.isEmpty()) {
            throw new Exception("Resource Id should not be null or empty");
        }
        String apiURL = this.getAPIURL("/rtype/" + resourceType + "/resource/" + resourceId);
        return SdkUtil.getInstance().deleteRequest(apiURL);
    }

    private String getAPIURL(String urlSubStr) throws Exception {
        String apiBaseURI = this.getApiBaseURI();
        SdkUtil.getInstance().setApiBaseURI(apiBaseURI);
        String apiURL = apiBaseURI;
        switch (this.authType) {
            case "Oauth2": {
                apiURL = apiURL + "/api/v2/tenants/" + this.tenantId + urlSubStr;
                break;
            }
            case "Basic": {
                apiURL = apiURL + "/api/basic/tenants/" + this.tenantId + urlSubStr;
                break;
            }
            case "None": {
                apiURL = apiURL + "/integrations/" + this.tenantId + "/apps/" + this.appName + urlSubStr;
                break;
            }
            default: {
                throw new Exception("Invalid authentication type: " + this.authType);
            }
        }
        return apiURL;
    }

    public void setBasicAuthentication(String apiUserName, String apiPassword) throws Exception {
        if (apiUserName == null || apiUserName.isEmpty()) {
            throw new Exception("API UserName should not be null or empty.");
        }
        if (apiPassword == null || apiPassword.isEmpty()) {
            throw new Exception("API Password should not be null or empty.");
        }
        this.authType = "Basic";
        SdkUtil.getInstance().setApiUserName(apiUserName);
        SdkUtil.getInstance().setApiPassword(apiPassword);
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setOAUTH2Authentication(String apiKey, String apiSecret) throws Exception {
        if (apiKey == null || apiKey.isEmpty()) {
            throw new Exception("API Key should not be null or empty.");
        }
        if (apiSecret == null || apiSecret.isEmpty()) {
            throw new Exception("API Secret should not be null or empty.");
        }
        this.authType = "Oauth2";
        SdkUtil.getInstance().setApiKey(apiKey);
        SdkUtil.getInstance().setApiSecret(apiSecret);
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setWebhookAuthentication() throws Exception {
        this.authType = "None";
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setApiBaseURI(String apiBaseURI) {
        this.apiBaseURI = apiBaseURI;
    }

    public String getApiBaseURI() {
        if (this.apiBaseURI == null) {
            return "https://api.vistara.io";
        }
        return this.apiBaseURI;
    }

    public static void main(String[] args) {
        try {
            String response = null;
            ResourceAPIClient resourceApiClient = ResourceAPIClient.getInstance("client_20");
            resourceApiClient.setApiBaseURI("https://localhost:9443");
            resourceApiClient.setOAUTH2Authentication("AyEYgZ7H6P473gaSM4nQGaSAbKqF5bQy", "EDzvdX2zM8CDGFvH5NkxyzFsxAsbVCQzCJ6KPBySTS46Trv5D8aSTfZDhBgM8ZCD");
            response = resourceApiClient.deleteResource("EBS", "vol-316e02d0");
            System.out.println("Response :" + response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

